#ifndef __CLevelMeter__
#define __CLevelMeter__

#include "CControl.hpp"
using Exponent::GUI::Controls::CControl;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @interface CLevelMeter CLevelMeter.hpp
			 * @brief Displays a level meter 
			 *
			 * @date 01/07/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CLevelMeter.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CLevelMeter : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param numberOfSteps The number of divisions to the level meter
				 */
				CLevelMeter(IControlRoot *root, const long uniqueId, const CRect &area, const long numberOfSteps);

				/**
				 * Destruction
				 */
				virtual ~CLevelMeter();

//	===========================================================================

				/**
				 * Set the value
				 * @param value The level of the meter, scaled 0 - 1
				 */
				virtual void setValue(const double value);

				/**
				 * Set the line colour
				 * @param lineColourMin The min value line colour
				 * @param lineColourMax The max value line colour
				 */
				virtual void setLineColour(const CAlphaColour &lineColourMin, const CAlphaColour &lineColourMax);

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

			protected:

//	===========================================================================

				long m_numberToDraw;					/**< Total stages to draw */
				long m_numberOfSteps;					/**< How many stages */
				bool m_isVertical;						/**< Are we vertical or horizontal */
				CDimension m_gradingDimension;			/**< Size of the grading */
				CAlphaColour m_lineColourMin;			/**< The min value line colour */
				CAlphaColour m_lineColourMax;			/**< The max value line colour */
				long deltaPerStep[3];					/**< Delta RGB values for each stage */
			};
		}
	}
}
#endif	// End of CLevelMeter.hpp